#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//CubeworldMod01.fsh   by   mla
//https://www.shadertoy.com/view/.....
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Cubeworld
// Matthew Arcus, mla, 2020
//
// The entire world consists of a single cube, each wall of the cube is just a
// passage back into the cube, through a different wall.
//
// Mouse to look around. Haven't worked out the details of doing lighting yet,
// so just uses fogging to indicate distance.
//
// Came out of thinking about tmst's excellent "Non-Euclidean World":
// https://www.shadertoy.com/view/WsXcWn
//
////////////////////////////////////////////////////////////////////////////////

const float PI = 3.1415927;
float AA = 2.0;
float maxdist = 15.0;
int maxiterations = 30;

bool alert = false;
void assert(bool b) {
  if (!b) alert = true;
}

float stepsize(vec3 p, vec3 r) {
  // Want least k such that p + kr has coordinate 1 in some dimension
  // eg. p.x+kr.x = 1 => k = (1-p.x)/r.x
  // eg. p.x+kr.x = 0 => k = -p.x/r.x
  // Want k positive, so assuming p.x is 0 < p.x < 1, depends on r.
  float k = 1e8;
  if (r.x > 0.0) k = (1.0-p.x)/r.x;
  else if (r.x < 0.0) k = min(k,-p.x/r.x);
  if (r.y > 0.0) k = min(k,(1.0-p.y)/r.y);
  else if (r.y < 0.0) k = min(k,-p.y/r.y);
  if (r.z > 0.0) k = min(k,(1.0-p.z)/r.z);
  else if (r.z < 0.0) k = min(k,-p.z/r.z);
  return k; // What if we cross 2 boundaries?
}

int gethitside(vec3 p) {
  if (p.x > 1.0) return 0;
  if (p.x < 0.0) return 1;
  if (p.y > 1.0) return 2;
  if (p.y < 0.0) return 3;
  if (p.z > 1.0) return 4;
  if (p.z < 0.0) return 5;
  return -1;
}

void nextdir(int hitside, inout vec3 r) {
  if (hitside == 0) { r.yz = vec2(r.z,-r.y); r.xz = r.zx; } // Reflection in x=y
  if (hitside == 1) { r.yz = vec2(r.z,-r.y); r.xz = vec2(-r.z,r.x); } // Rotation by 90 deg
  if (hitside == 4) { r.xz = vec2(r.z,-r.x); r.yz = vec2(-r.z,r.y); } // Opposite rotation by 90 deg
  if (hitside == 5) { r.xz = r.zx; r.yz = vec2(-r.z,r.y); } // Reflection in x=y
}

void nextpos(int hitside, inout vec3 p) {
  if (hitside == 0) p.x -= 1.0;
  if (hitside == 1) p.x += 1.0;
  if (hitside == 2) p.y -= 1.0;
  if (hitside == 3) p.y += 1.0;
  if (hitside == 4) p.z -= 1.0;
  if (hitside == 5) p.z += 1.0;
  if (hitside == 0) { p.yz = vec2(p.z,1.0-p.y); p.xz = p.zx; } // Reflection in x=y
  if (hitside == 1) { p.yz = vec2(p.z,1.0-p.y); p.xz = vec2(1.0-p.z,p.x); } // Rotation by 90 deg
  if (hitside == 4) { p.xz = vec2(p.z,1.0-p.x); p.yz = vec2(1.0-p.z,p.y); } // Opposite rotation by 90 deg
  if (hitside == 5) { p.xz = p.zx; p.yz = vec2(1.0-p.z,p.y); } // Reflection in x=y
}

bool traceray(inout vec3 p, inout vec3 r, out vec3 n, out int type, out float totaldist) {
  totaldist = 0.0;
  vec3 p0 = p;
  for (int i = 0; i < maxiterations; i++) {
    if (i > 0) {
      // find intersection with sphere at p0
      vec3 q = p-p0;
      //(q+kr).(q+kr) = r2
      float A = dot(r,r);
      float B = dot(q,r);
      float r = 0.05;
      float r2 = r*r;
      float C = dot(q,q)-r2;
      float D = B*B-A*C;
      if (D >= 0.0) {
        float t = (-B-sqrt(D))/A;
        totaldist += t;
        n = q+t*r;
        type = 6;
        return true;
      }
    }
    float eps = 1e-3;
    float k = stepsize(p,r)+eps;
    p += k*r;
    totaldist += k;
    if (totaldist > maxdist) return false;
    // determine the hit side
    int hitside = gethitside(p);
    type = hitside;
    vec3 border = min(p,1.0-p);
    // Have we hit the wall frames?
    if (hitside/2 == 0 && min(border.y,border.z) < 0.05) { n = vec3(1,0,0); return true; }
    if (hitside/2 == 1 && min(border.z,border.x) < 0.05) { n = vec3(0,1,0); return true; }
    if (hitside/2 == 2 && min(border.x,border.y) < 0.05) { n = vec3(0,0,1); return true; }
    // Advance p and r
    nextpos(hitside,p);
    nextdir(hitside,r);
  }
  return false;
}

void moveforward(inout vec3 p, inout vec3 r, vec3 dir, float t) {
  for (int i = 0; i < 50; i++) {
    float k = stepsize(p,dir) ;
    float eps = 1e-3;
    if (t <= k) break;
    k += eps;
    p += k*dir;
    t -= k;
    int hitside = gethitside(p);
    nextpos(hitside,p);
    nextdir(hitside,dir);
    nextdir(hitside,r);
  }
  p += t*dir;
}

vec3 getcolor(int type) {
  if (type == 0) return vec3(1,0,0);
  if (type == 1) return vec3(0,1,0);
  if (type == 2) return vec3(0,0,1);
  if (type == 3) return vec3(1,1,0);
  if (type == 4) return vec3(1,0,1);
  if (type == 5) return vec3(0,1,1);
  return vec3(0.2);
}

vec3 raycolor(vec3 p, vec3 r) {
    int type; vec3 n; float totaldist;
    vec3 bgcol = vec3(1,1,0.5);
    //vec3 bgcol = vec3(1);
    if (!traceray(p,r,n,type,totaldist)) return bgcol;
    vec3 basecolor = getcolor(type);
    vec3 color = basecolor;
    color *= 0.5;
    color = mix(color,bgcol,totaldist/maxdist);
    return color;
}

vec2 rotate(vec2 p, float t) {
  return mat2(cos(t),sin(t),-sin(t),cos(t))*p;
}

vec3 transform(in vec3 p) {
  if (iMouse.x > 0.0) {
    float theta = -(2.0*iMouse.y-iResolution.y)/iResolution.y*PI;
    float phi = -(2.0*iMouse.x-iResolution.x)/iResolution.x*PI;
    p.yz = rotate(p.yz,theta);
    p.zx = rotate(p.zx,-phi);
  }
  if (false) {
    p.zx = rotate(p.zx,iTime * 0.2);
    p.xy = rotate(p.xy,iTime * 0.125);
  }
  return p;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
  vec3 col = vec3(0);
  for (float i = 0.0; i < AA; i++) {
    for (float j = 0.0; j < AA; j++) {
      vec2 uv = (2.0*(fragCoord+vec2(i,j)/AA)-iResolution.xy)/iResolution.y;
      vec3 r = vec3(uv,2);
      vec3 p = vec3(0.5);
      r = transform(r);
      r = normalize(r); // Normalize after transform
      moveforward(p,r,vec3(0,0,1),mod(0.2*iTime,4.0));
      vec3 c = raycolor(p,r);
      col += c;
    }
  }
  col /= float(AA*AA);
  col = pow(col,vec3(0.4545));
  if (alert) col = vec3(1,0,0);
  fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

